
USE MASTER
GO

/**** BUAT DATABASE: iklan ******/
CREATE DATABASE Iklan
ON 
( NAME = iklan,
  FILENAME = 'c:\mssql7\data\iklan.mdf',
  SIZE = 4,
  MAXSIZE = 10,
  FILEGROWTH = 1 )
GO

/****** Object:  Login news  ******/
/****** USERNAME: news, PASSWORD: news ********/
if not exists (select * from master..syslogins where name = N'news')
BEGIN
	declare @logindb nvarchar(132), @loginlang nvarchar(132) select @logindb = N'Iklan', @loginlang = N'us_english'
	if @logindb is null or not exists (select * from master..sysdatabases where name = @logindb)
		select @logindb = N'Iklan'
	if @loginlang is null or (not exists (select * from master..syslanguages where name = @loginlang) and @loginlang <> N'us_english')
		select @loginlang = @@language
	exec sp_addlogin N'news', 'news', @logindb, @loginlang
END
GO

USE iklan
GO

/****** Object:  User dbo   ******/
/****** Object:  User news  ******/
if not exists (select * from sysusers where name = N'news' and uid < 16382)
	EXEC sp_grantdbaccess N'news', N'news'
GO

/****** Object:  User news  ******/
exec sp_addrolemember N'db_owner', N'news'
GO

/****** Object:  Table [dbo].[anggota]  ******/
CREATE TABLE [dbo].[anggota] (
	[id] [int] NOT NULL ,
	[nama] [char] (25) NULL ,
	[alamat] [char] (40) NULL ,
	[kota] [char] (20) NULL ,
	[email] [char] (35) NULL ,
	[jeniskelamin] [char] (6) NULL ,
	[pekerjaan] [char] (20) NULL ,
	[username] [char] (20) NOT NULL ,
	[passwd] [char] (20) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[bukutamu]  ******/
CREATE TABLE [dbo].[bukutamu] (
	[id] [int] NOT NULL ,
	[pengirim] [varchar] (25) NULL ,
	[email] [varchar] (35) NULL ,
	[tanggal] [smalldatetime] NULL ,
	[isi] [varchar] (250) NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[iklan]  ******/
CREATE TABLE [dbo].[iklan] (
	[IDiklan] [int] NOT NULL ,
	[IDanggota] [int] NOT NULL ,
	[tanggal] [smalldatetime] NULL ,
	[kategori] [char] (13) NOT NULL ,
	[isi] [varchar] (250) NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[anggota] WITH NOCHECK ADD 
	CONSTRAINT [PK_anggota] PRIMARY KEY  NONCLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bukutamu] WITH NOCHECK ADD 
	CONSTRAINT [PK_bukutamu] PRIMARY KEY  NONCLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[iklan] ADD 
	CONSTRAINT [FK_iklan_anggota] FOREIGN KEY 
	(
		[IDanggota]
	) REFERENCES [dbo].[anggota] (
		[id]
	)
GO

